

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;
float4x4	shader_light_view;
float4x4	shader_light_viewProj;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

float4		terrainDistanceMap_sunAmbient;
float4		terrainDistanceMap_sunDiffuse;

float2		terrainDistanceMap_base_texOffset;
float		terrainDistanceMap_base_texMulti;

float2		terrainDistanceMap_texOffset;
float		terrainDistanceMap_texMulti;

float2		terrainDistanceMap_blendOffset;
float		terrainDistanceMap_blendMulti;

float		terrainDistanceMap_detailMulti;


struct VS_INPUT 
{
	float4 position		: POSITION;
	float4 colour		: COLOR;
	
	float2 uv1			: TEXCOORD0;
};
	
	
struct VS_OUTPUT 
{
	float4 position		: POSITION;

	float2 uv1			: TEXCOORD0;
};


VS_OUTPUT vs_terrainDistanceMapLit( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;
	
	output.position = input.position;
	output.uv1 = input.uv1;

	return output;
}

////////////////////////////////////////////////////////////

sampler sampler_colour_1 = sampler_state
{
	Texture = (shader_texture_0);
	AddressU=Clamp;
	AddressV=Clamp;
};

sampler sampler_colour_2 = sampler_state
{
	Texture = (shader_texture_1);
	AddressU=Wrap;
	AddressV=Wrap;
};

sampler sampler_colour_3 = sampler_state
{
	Texture = (shader_texture_2);
	AddressU=Wrap;
	AddressV=Wrap;
};

sampler sampler_colour_4 = sampler_state
{
	Texture = (shader_texture_3);
	AddressU=Wrap;
	AddressV=Wrap;
};

sampler sampler_colour_5 = sampler_state
{
	Texture = (shader_texture_4);
	AddressU=Wrap;
	AddressV=Wrap;
};

////////////////////////////////////////////////////////////

float4 ps_terrainDistanceMapLit( VS_OUTPUT input ) : COLOR0
{
	float2 nBlendUv = terrainDistanceMap_blendOffset + input.uv1 * terrainDistanceMap_blendMulti;

	//return float4(tex2D(sampler_colour_1, nBlendUv).a,0,0,1);
	
	float2 nBaseUv = terrainDistanceMap_base_texOffset + input.uv1 * terrainDistanceMap_base_texMulti;

	float2 nDetailUv = terrainDistanceMap_texOffset + input.uv1 * terrainDistanceMap_texMulti;
	
	
	float3 nBaseColour = tex2D(sampler_colour_2, nBaseUv).rgb;
	
	nBaseColour = lerp(nBaseColour, tex2D(sampler_colour_3, nBaseUv).rgb, tex2D(sampler_colour_1, nBlendUv).r);
	nBaseColour = lerp(nBaseColour, tex2D(sampler_colour_4, nBaseUv).rgb, tex2D(sampler_colour_1, nBlendUv).g);
	nBaseColour = lerp(nBaseColour, tex2D(sampler_colour_5, nBaseUv).rgb, tex2D(sampler_colour_1, nBlendUv).b);
	
	
	float3 nDetailColour = tex2D(sampler_colour_2, nDetailUv).rgb;
	
	nDetailColour = lerp(nDetailColour, tex2D(sampler_colour_3, nDetailUv).rgb, tex2D(sampler_colour_1, nBlendUv).r);
	nDetailColour = lerp(nDetailColour, tex2D(sampler_colour_4, nDetailUv).rgb, tex2D(sampler_colour_1, nBlendUv).g); // + tex2D(sampler_colour_4, nDetailUv).r );
	nDetailColour = lerp(nDetailColour, tex2D(sampler_colour_5, nDetailUv).rgb, tex2D(sampler_colour_1, nBlendUv).b); // + tex2D(sampler_colour_5, nDetailUv).r );
	

	return
	
			// lighting

			float4( (terrainDistanceMap_sunAmbient.rgb + terrainDistanceMap_sunDiffuse.rgb * tex2D(sampler_colour_1, nBlendUv).a) *
			
			// base colour

			saturate(nBaseColour + 0.4f) * saturate(nDetailColour) * 1.25f, // * 1.4f),

			1);
}


technique terrainDistanceMapLit_11_20
{
	pass P0
	{
		AlphaBlendEnable = False;
		AlphaTestEnable = False;

		VertexShader = compile vs_1_1 vs_terrainDistanceMapLit();	
		PixelShader = compile ps_2_0 ps_terrainDistanceMapLit();	
	}
}

technique terrainDistanceMapLit_11_00
{
	pass P0
	{
	}
}